/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public interface IBucketable {
    public boolean isFromBucket();

    public void setFromBucket(boolean var1);

    public void copyToStack(ItemStack var1);

    public void copyFromAdditional(CompoundTag var1);

    public ItemStack getBucketItem();

    public SoundEvent getBucketedSound();

    public static void copyToStack(Mob entity, ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        if (entity.m_8077_()) {
            stack.m_41714_(entity.m_7770_());
        }
        if (entity.m_21525_()) {
            compound.m_128379_("NoAI", entity.m_21525_());
        }
        if (entity.m_20067_()) {
            compound.m_128379_("Silent", entity.m_20067_());
        }
        if (entity.m_20068_()) {
            compound.m_128379_("NoGravity", entity.m_20068_());
        }
        if (entity.m_142038_()) {
            compound.m_128379_("Glowing", entity.m_142038_());
        }
        if (entity.m_20147_()) {
            compound.m_128379_("Invulnerable", entity.m_20147_());
        }
        compound.m_128350_("Health", entity.m_21223_());
    }

    public static void copyFromAdditional(Mob entity, CompoundTag compound) {
        if (compound.m_128441_("NoAI")) {
            entity.m_21557_(compound.m_128471_("NoAI"));
        }
        if (compound.m_128441_("Silent")) {
            entity.m_20225_(compound.m_128471_("Silent"));
        }
        if (compound.m_128441_("NoGravity")) {
            entity.m_20242_(compound.m_128471_("NoGravity"));
        }
        if (compound.m_128441_("Glowing")) {
            entity.m_146915_(compound.m_128471_("Glowing"));
        }
        if (compound.m_128441_("Invulnerable")) {
            entity.m_20331_(compound.m_128471_("Invulnerable"));
        }
        if (compound.m_128425_("Health", 99)) {
            entity.m_21153_(compound.m_128457_("Health"));
        }
    }

    public static <T extends LivingEntity> Optional<InteractionResult> tryBucketEntity(Player player, InteractionHand hand, T entity) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() == Items.f_42448_ && entity.m_6084_()) {
            entity.m_5496_(((IBucketable)entity).getBucketedSound(), 1.0f, 1.0f);
            heldItem.m_41774_(1);
            ItemStack bucketItem = ((IBucketable)entity).getBucketItem();
            ((IBucketable)entity).copyToStack(bucketItem);
            Level world = entity.f_19853_;
            if (!world.f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucketItem);
            }
            if (heldItem.m_41619_()) {
                player.m_21008_(hand, bucketItem);
            } else if (!player.m_150109_().m_36054_(bucketItem)) {
                player.m_36176_(bucketItem, false);
            }
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
            return Optional.of(InteractionResult.m_19078_((boolean)world.f_46443_));
        }
        return Optional.empty();
    }
}

